<?php

namespace MyTerroir;

use Illuminate\Database\Eloquent\Model;

class Seller extends Model 
{

    protected $table = 'tabSeller';
    public $timestamps = false;
    protected $fillable = array('avatar', 'name', 'preferred_language', 'contact_person', 'phone_no', 'post_code', 'slug', 'commission', 'rating');

    public function getSellerWorkingDays()
    {
        return $this->hasMany('SellerWorkingDays', 'seller_id');
    }

    public function getSellerHolidays()
    {
        return $this->hasMany('SellerHolidays', 'seller_id');
    }

    public function getSellerPickupLocations()
    {
        return $this->hasMany('SellerPickLocations', 'seller_id');
    }

}