<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTabPressReleaseTable extends Migration {

	public function up()
	{
		Schema::create('tabPressRelease', function(Blueprint $table) {
			$table->increments('id');
			$table->string('avatar')->nullable();
			$table->string('title');
			$table->text('description')->nullable();
			$table->date('published_date')->nullable();
			$table->string('status')->default('Active');
			$table->string('page_url')->nullable();
			$table->string('slug');
			$table->string('owner');
			$table->string('last_updated_by');
			$table->timestamp('created_at');
			$table->timestamp('updated_at');
		});
	}

	public function down()
	{
		Schema::drop('tabPressRelease');
	}
}