<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCitiesTable extends Migration {

	public function up()
	{
		Schema::create('cities', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->boolean('is_active')->default(true);
			$table->integer('country_id')->unsigned();
			$table->string('time_zone')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('cities');
	}
}