<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePresentesTable extends Migration {

	public function up()
	{
		Schema::create('presentes', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('produtos_id')->unsigned();
			$table->integer('eventos_id')->unsigned();
			$table->string('nome', 254);
			$table->string('email', 254);
			$table->string('telefone', 20)->nullable();
			$table->text('mensagem')->nullable();
			$table->float('valor');
			$table->float('valorextra')->nullable();
			$table->float('valortaxa')->nullable();
			$table->float('valorpago');
			$table->datetime('dtregistrado');
		});
	}

	public function down()
	{
		Schema::drop('presentes');
	}
}