<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('eventos', function(Blueprint $table) {
			$table->foreign('tiposeventos_id')->references('id')->on('tiposeventos')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('eventos', function(Blueprint $table) {
			$table->foreign('cerimoniais_id')->references('id')->on('cerimoniais')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('eventos', function(Blueprint $table) {
			$table->foreign('templates_id')->references('id')->on('templates')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('templates', function(Blueprint $table) {
			$table->foreign('tiposeventos_id')->references('id')->on('tiposeventos')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('produtos', function(Blueprint $table) {
			$table->foreign('categoriasprodutos_id')->references('id')->on('categoriasprodutos')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('produtos', function(Blueprint $table) {
			$table->foreign('tiposeventos_id')->references('id')->on('eventos')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('presentes', function(Blueprint $table) {
			$table->foreign('produtos_id')->references('id')->on('produtos')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('presentes', function(Blueprint $table) {
			$table->foreign('eventos_id')->references('id')->on('eventos')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('presentesextras', function(Blueprint $table) {
			$table->foreign('presentes_id')->references('id')->on('presentes')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('presentesextras', function(Blueprint $table) {
			$table->foreign('produtos_id')->references('id')->on('produtos')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('usuarios', function(Blueprint $table) {
			$table->foreign('permissoes_id')->references('id')->on('permissoes')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('lancamentos', function(Blueprint $table) {
			$table->foreign('presentes_id')->references('id')->on('presentes')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('lancamentos', function(Blueprint $table) {
			$table->foreign('saques_id')->references('id')->on('saques')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('eventosfotos', function(Blueprint $table) {
			$table->foreign('eventos_id')->references('id')->on('eventos')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('eventosrecados', function(Blueprint $table) {
			$table->foreign('eventos_id')->references('id')->on('eventos')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('eventospaginas', function(Blueprint $table) {
			$table->foreign('eventos_id')->references('id')->on('eventos')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('eventosrsvps', function(Blueprint $table) {
			$table->foreign('eventos_id')->references('id')->on('eventos')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('eventosconfiguracoes', function(Blueprint $table) {
			$table->foreign('eventos_id')->references('id')->on('eventos')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('eventosprodutos', function(Blueprint $table) {
			$table->foreign('eventos_id')->references('id')->on('eventos')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('eventosprodutos', function(Blueprint $table) {
			$table->foreign('produtos_id')->references('id')->on('produtos')
						->onDelete('no action')
						->onUpdate('no action');
		});
	}

	public function down()
	{
		Schema::table('eventos', function(Blueprint $table) {
			$table->dropForeign('eventos_tiposeventos_id_foreign');
		});
		Schema::table('eventos', function(Blueprint $table) {
			$table->dropForeign('eventos_cerimoniais_id_foreign');
		});
		Schema::table('eventos', function(Blueprint $table) {
			$table->dropForeign('eventos_templates_id_foreign');
		});
		Schema::table('templates', function(Blueprint $table) {
			$table->dropForeign('templates_tiposeventos_id_foreign');
		});
		Schema::table('produtos', function(Blueprint $table) {
			$table->dropForeign('produtos_categoriasprodutos_id_foreign');
		});
		Schema::table('produtos', function(Blueprint $table) {
			$table->dropForeign('produtos_tiposeventos_id_foreign');
		});
		Schema::table('presentes', function(Blueprint $table) {
			$table->dropForeign('presentes_produtos_id_foreign');
		});
		Schema::table('presentes', function(Blueprint $table) {
			$table->dropForeign('presentes_eventos_id_foreign');
		});
		Schema::table('presentesextras', function(Blueprint $table) {
			$table->dropForeign('presentesextras_presentes_id_foreign');
		});
		Schema::table('presentesextras', function(Blueprint $table) {
			$table->dropForeign('presentesextras_produtos_id_foreign');
		});
		Schema::table('usuarios', function(Blueprint $table) {
			$table->dropForeign('usuarios_permissoes_id_foreign');
		});
		Schema::table('lancamentos', function(Blueprint $table) {
			$table->dropForeign('lancamentos_presentes_id_foreign');
		});
		Schema::table('lancamentos', function(Blueprint $table) {
			$table->dropForeign('lancamentos_saques_id_foreign');
		});
		Schema::table('eventosfotos', function(Blueprint $table) {
			$table->dropForeign('eventosfotos_eventos_id_foreign');
		});
		Schema::table('eventosrecados', function(Blueprint $table) {
			$table->dropForeign('eventosrecados_eventos_id_foreign');
		});
		Schema::table('eventospaginas', function(Blueprint $table) {
			$table->dropForeign('eventospaginas_eventos_id_foreign');
		});
		Schema::table('eventosrsvps', function(Blueprint $table) {
			$table->dropForeign('eventosrsvps_eventos_id_foreign');
		});
		Schema::table('eventosconfiguracoes', function(Blueprint $table) {
			$table->dropForeign('eventosconfiguracoes_eventos_id_foreign');
		});
		Schema::table('eventosprodutos', function(Blueprint $table) {
			$table->dropForeign('eventosprodutos_eventos_id_foreign');
		});
		Schema::table('eventosprodutos', function(Blueprint $table) {
			$table->dropForeign('eventosprodutos_produtos_id_foreign');
		});
	}
}