<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateEventsTable extends Migration {

	public function up()
	{
		Schema::create('events', function(Blueprint $table) {
			$table->increments('id');
			$table->string('uuid', 64);
			$table->integer('client_id');
			$table->integer('lieu_id');
			$table->integer('type_id');
			$table->string('name', 64);
			$table->integer('guests_number');
			$table->datetime('start_date');
			$table->datetime('end_date');
			$table->integer('status_id');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('events');
	}
}