<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateRfCompaniesTable extends Migration {

	public function up()
	{
		Schema::create('rf_companies', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('user_id')->unsigned();
			$table->string('name_ar', 150);
			$table->string('name_en', 150);
			$table->integer('commercial_registration_no');
			$table->string('tax_identifier_no');
			$table->string('address', 150);
			$table->string('website');
			$table->string('source');
			$table->boolean('is_active')->default(1);
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('rf_companies');
	}
}