<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateRfLeaseUnitTable extends Migration {

	public function up()
	{
		Schema::create('rf_lease_unit', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('rf_unit_id')->unsigned();
			$table->bigInteger('rf_lease_id')->unsigned();
			$table->enum('rental_annual_type', array('total', 'sql'))->nullable();
			$table->double('annual_rental_amount', 10.2)->default('0');
			$table->json('property_history')->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('rf_lease_unit');
	}
}