<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateRfUnitsTable extends Migration {

	public function up()
	{
		Schema::create('rf_units', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 191);
			$table->integer('category_id')->unsigned();
			$table->integer('type_id')->unsigned();
			$table->integer('rf_community_id')->unsigned()->nullable();
			$table->integer('rf_building_id')->unsigned()->nullable();
			$table->date('year_build')->nullable();
			$table->json('map')->nullable();
			$table->bigInteger('tenant_id')->unsigned();
			$table->bigInteger('owner_id')->unsigned();
			$table->bigInteger('views')->default('0');
			$table->integer('status_id');
			$table->boolean('is_active')->default(1);
			$table->boolean('is_buy')->default(0);
			$table->boolean('is_market_place')->default(0);
			$table->bigInteger('created_by')->unsigned()->nullable();
			$table->bigInteger('updated_by')->unsigned()->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('rf_units');
	}
}