<?php

namespace RFTenant\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class RfUnitRoom extends Eloquent {

	protected $table = 'rf_unit_rooms';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name_ar', 'name_en', 'value', 'rf_unit_id');

	public function unit()
	{
		return $this->belongsTo('RFTenant\Models\RfUnits');
	}

}