<?php

namespace RFTenant\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class RfUnits extends Eloquent {

	protected $table = 'rf_units';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name', 'type_id', 'rf_community_id', 'rf_building_id', 'year_build', 'map', 'tenant_id', 'owner_id', 'views', 'status_id', 'is_active', 'is_buy', 'is_market_place', 'created_by', 'updated_by');

	public function unit_rooms()
	{
		return $this->hasMany('RFTenant\Models\RfUnitRoom');
	}

	public function unit_areas()
	{
		return $this->hasMany('RFTenant\Models\RfUnitArea');
	}

	public function specifications()
	{
		return $this->belongsToMany('RFTenant\Models\RfSpecification');
	}

	public function category()
	{
		return $this->belongsTo('RFTenant\Models\RfSpecification', 'category_id');
	}

	public function type()
	{
		return $this->belongsTo('RFTenant\Models\RfSpecification', 'type_id');
	}

	public function community()
	{
		return $this->belongsTo('RFTenant\Models\RfCommunity');
	}

	public function building()
	{
		return $this->belongsTo('RFTenant\Models\RfBuildings');
	}

	public function specification_unit()
	{
		return $this->hasMany('RFTenant\Models\RfSpecificationUnit');
	}

	public function unit_marketplace()
	{
		return $this->hasMany('RFTenant\Models\UnitMarketplace');
	}

	public function lease()
	{
		return $this->hasMany('RfLease');
	}

}