<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateLoanMtTable extends Migration {

	public function up()
	{
		Schema::create('loan_mt', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('docno');
			$table->date('apply_date');
			$table->char('employee', 10);
			$table->decimal('total', 14,2);
			$table->string('repay_term');
			$table->integer('tenure');
			$table->string('approve1_by');
			$table->string('approve1_datetime');
			$table->string('approve1_feedback');
			$table->enum('approve1_action', array(''));
			$table->string('approve2_by');
			$table->datetime('approve2_datetime');
			$table->string('approve2_feedback');
			$table->string('approve2_action');
			$table->string('approve3_by');
			$table->datetime('approve3_datetime');
			$table->string('approve3_feedback');
			$table->enum('approve3_action', array(''));
			$table->enum('status', array(''));
		});
	}

	public function down()
	{
		Schema::drop('loan_mt');
	}
}