<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateLoanTrnTable extends Migration {

	public function up()
	{
		Schema::create('loan_trn', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->char('employee', 10);
			$table->char('docno', 10);
			$table->date('term');
			$table->decimal('total', 14,2);
			$table->tinyInteger('payroll');
		});
	}

	public function down()
	{
		Schema::drop('loan_trn');
	}
}