<?php

namespace App/Model/FlashCard;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class FlashCard extends Model 
{

    protected $table = 'flashcards';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('lesson_id', 'english_word', 'arabic_word', 'pronuciation', 'status');

    public function lesson()
    {
        return $this->belongsTo('Lesson', 'lesson_id');
    }

}