<?php

namespace App/Model/Quiz;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Quiz extends Model 
{

    protected $table = 'quiz';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('degree', 'lesson_id', 'status');

    public function lesson()
    {
        return $this->belongsTo('Lesson', 'lesson_id');
    }

}