<?php

namespace App/Model/Section;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Section extends Model 
{

    protected $table = 'sections';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('page_id');

    public function sectionItems()
    {
        return $this->hasMany('SectionItem', 'section_id');
    }

}