<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrderItemsTable extends Migration {

	public function up()
	{
		Schema::create('order_items', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->bigInteger('order_id')->unsigned();
			$table->bigInteger('course_id')->unsigned();
			$table->bigInteger('level_id')->unsigned();
			$table->integer('sale_price');
			$table->integer('status')->default('0');
		});
	}

	public function down()
	{
		Schema::drop('order_items');
	}
}