<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateQuizAnswersTable extends Migration {

	public function up()
	{
		Schema::create('quiz_answers', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->bigInteger('question_id')->unsigned();
			$table->text('answer');
			$table->integer('correct')->default('0');
			$table->enum('type', array('lesson', 'placementtest'));
		});
	}

	public function down()
	{
		Schema::drop('quiz_answers');
	}
}