<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateReviewsTable extends Migration {

	public function up()
	{
		Schema::create('reviews', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('rate');
			$table->text('comment');
			$table->bigInteger('reviewable_id');
			$table->string('reviewable_type');
			$table->integer('status')->default('0');
			$table->softDeletes();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('reviews');
	}
}