<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('post_categories', function(Blueprint $table) {
			$table->foreign('created_by')->references('id')->on('users')
						->onDelete('set null')
						->onUpdate('restrict');
		});
		Schema::table('post_categories', function(Blueprint $table) {
			$table->foreign('updated_by')->references('id')->on('users')
						->onDelete('set null')
						->onUpdate('restrict');
		});
		Schema::table('posts', function(Blueprint $table) {
			$table->foreign('post_category_id')->references('id')->on('post_categories')
						->onDelete('set null')
						->onUpdate('restrict');
		});
		Schema::table('posts', function(Blueprint $table) {
			$table->foreign('created_by')->references('id')->on('users')
						->onDelete('set null')
						->onUpdate('restrict');
		});
		Schema::table('posts', function(Blueprint $table) {
			$table->foreign('updated_by')->references('id')->on('users')
						->onDelete('set null')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('post_categories', function(Blueprint $table) {
			$table->dropForeign('post_categories_created_by_foreign');
		});
		Schema::table('post_categories', function(Blueprint $table) {
			$table->dropForeign('post_categories_updated_by_foreign');
		});
		Schema::table('posts', function(Blueprint $table) {
			$table->dropForeign('posts_post_category_id_foreign');
		});
		Schema::table('posts', function(Blueprint $table) {
			$table->dropForeign('posts_created_by_foreign');
		});
		Schema::table('posts', function(Blueprint $table) {
			$table->dropForeign('posts_updated_by_foreign');
		});
	}
}