<?php

namespace App\Models;

class Post extends Eloquent {

	protected $table = 'posts';
	public $timestamps = false;

	public function category()
	{
		return $this->belongsTo('PostCategory', 'post_category_id');
	}

	public function creator()
	{
		return $this->belongsTo('User', 'created_by');
	}

	public function updator()
	{
		return $this->belongsTo('User', 'updated_by');
	}

	public function posts()
	{
		return $this->belongsToMany('Post', 'PostsPost');
	}

}