<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCustomerPaymentMethodsTable extends Migration {

	public function up()
	{
		Schema::create('customer_payment_methods', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('customer_id');
			$table->integer('address_id');
			$table->string('billing_provider_token', 50)->nullable();
			$table->string('card_type', 25)->nullable();
			$table->string('cardholder_name', 175)->nullable();
			$table->string('masked_number', 50);
			$table->integer('expiration_date');
			$table->string('issuing_bank', 100);
			$table->tinyInteger('prepaid')->nullable();
			$table->tinyInteger('expired')->nullable();
			$table->boolean('is_default');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('customer_payment_methods');
	}
}