<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCustomerStorableLogsTable extends Migration {

	public function up()
	{
		Schema::create('customer_storable_logs', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('customer_storable_id');
			$table->integer('user_id');
			$table->enum('action', array(''));
			$table->text('message')->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('customer_storable_logs');
	}
}