<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateInvoiceTransactionsTable extends Migration {

	public function up()
	{
		Schema::create('invoice_transactions', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('invoice_id');
			$table->string('billing_provider_transaction_id', 50);
			$table->enum('type', array('credit', 'debit'));
			$table->float('amount');
			$table->enum('status', array('open', 'closed', 'pending', 'void'));
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('invoice_transactions');
	}
}