<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('attachments', function(Blueprint $table) {
			$table->foreign('ref_id')->references('id')->on('members')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('jobs', function(Blueprint $table) {
			$table->foreign('parent_id')->references('id')->on('jobs')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('MemberServices', function(Blueprint $table) {
			$table->foreign('member_id')->references('id')->on('members')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('MemberServices', function(Blueprint $table) {
			$table->foreign('service_id')->references('id')->on('services')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('attachments', function(Blueprint $table) {
			$table->dropForeign('attachments_ref_id_foreign');
		});
		Schema::table('jobs', function(Blueprint $table) {
			$table->dropForeign('jobs_parent_id_foreign');
		});
		Schema::table('MemberServices', function(Blueprint $table) {
			$table->dropForeign('MemberServices_member_id_foreign');
		});
		Schema::table('MemberServices', function(Blueprint $table) {
			$table->dropForeign('MemberServices_service_id_foreign');
		});
	}
}