<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCompanyTable extends Migration {

	public function up()
	{
		Schema::create('Company', function(Blueprint $table) {
			$table->increments('_id');
			$table->string('name');
			$table->string('display_picture');
			$table->string('phone');
			$table->string('address');
			$table->string('website');
			$table->string('owner');
			$table->enum('company_type', array('single-store', 'multi-store'));
			$table->string('categories');
		});
	}

	public function down()
	{
		Schema::drop('Company');
	}
}