<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePupilLessonRegistrationTable extends Migration {

	public function up()
	{
		Schema::create('pupil_lesson_registration', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('status', 16)->index();
			$table->integer('planned_lesson_id')->unsigned();
			$table->integer('pupil_id')->unsigned();
			$table->integer('course_product_id')->unsigned();
			$table->decimal('price');
		});
	}

	public function down()
	{
		Schema::drop('pupil_lesson_registration');
	}
}