<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSublocationsTable extends Migration {

	public function up()
	{
		Schema::create('sublocations', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('name');
			$table->string('code');
			$table->integer('ordering');
			$table->integer('location_id')->unsigned()->index();
		});
	}

	public function down()
	{
		Schema::drop('sublocations');
	}
}