<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSubscriptionsTable extends Migration {

	public function up()
	{
		Schema::create('subscriptions', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('name');
			$table->string('code', 16);
			$table->string('duration');
			$table->string('price_type');
			$table->decimal('price');
		});
	}

	public function down()
	{
		Schema::drop('subscriptions');
	}
}