<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Customer extends Eloquent {

	protected $table = 'customers';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function user()
	{
		return $this->hasOne('User');
	}

	public function pupils()
	{
		return $this->hasMany('Pupil');
	}

}