<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Location extends Eloquent {

	protected $table = 'locations';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function schools()
	{
		return $this->belongsToMany('School');
	}

	public function sections()
	{
		return $this->hasMany('Section');
	}

	public function sublocations()
	{
		return $this->hasMany('Sublocation');
	}

	public function schedules()
	{
		return $this->morphMany('Schedule');
	}

}