<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class StaffMember extends Eloquent {

	protected $table = 'staff_members';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function user()
	{
		return $this->hasOne('User');
	}

	public function functionTitles()
	{
		return $this->hasMany('FunctionTitle');
	}

	public function schedules()
	{
		return $this->morphMany('Schedule');
	}

}