<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateLeadsTable extends Migration {

	public function up()
	{
		Schema::create('leads', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id_to')->unsigned()->index();
			$table->integer('user_id_from')->nullable()->index();
			$table->integer('property_id')->unsigned();
			$table->string('name', 191);
			$table->string('email', 191);
			$table->string('phone', 20);
			$table->text('message');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('leads');
	}
}