<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePropertyAttachmentsTable extends Migration {

	public function up()
	{
		Schema::create('property_attachments', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('property_id')->unsigned();
			$table->string('name', 191);
			$table->boolean('is_featured')->nullable()->default(0);
			$table->string('mime_type', 191)->nullable();
			$table->string('size')->nullable()->default('0');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('property_attachments');
	}
}