<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Property extends Eloquent {

	protected $table = 'properties';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function package()
	{
		return $this->hasOne('App\Package', 'id', 'package_id');
	}

	public function attechments()
	{
		return $this->belongsToMany('App\User');
	}

	public function leads()
	{
		return $this->belongsToMany('App\Lead');
	}

	public function favorites()
	{
		return $this->belongsToMany('App\Favorite');
	}

	public function user()
	{
		return $this->belongsTo('App\User');
	}

	public function country()
	{
		return $this->belongsTo('App\Country');
	}

	public function property_type()
	{
		return $this->belongsTo('App\PropertyType', 'property_type_id');
	}

	public function aditional_property_type()
	{
		return $this->belongsTo('App\PropertyType', 'additional_property_type_id');
	}

	public function currency()
	{
		return $this->belongsTo('App\Currency');
	}

}