<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class User extends Eloquent {

	protected $table = 'users';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function properties()
	{
		return $this->belongsToMany('App\Property');
	}

	public function favorites()
	{
		return $this->belongsToMany('App\Favorite');
	}

	public function package()
	{
		return $this->hasOne('App\User', 'id', 'package_id');
	}

}