<?php

namespace App\Models\Challenges;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class ChallengeElement extends Eloquent {

	protected $table = 'challenge_elements';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function getChallenge()
	{
		return $this->belongsTo('Challenge');
	}

	public function getQuiz()
	{
		return $this->belongsTo('Quiz');
	}

	public function getEventRealization()
	{
		return $this->belongsTo('EventRealization');
	}

	public function getActivity()
	{
		return $this->belongsTo('Activity');
	}

}