<?php

namespace App\Models\Keywords;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Keyword extends Eloquent {

	protected $table = 'keywords';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function getQuizes()
	{
		return $this->belongsToMany('Quiz', 'quiz_keyword');
	}

	public function getChallenges()
	{
		return $this->belongsToMany('Challenge', 'challenge_keywords');
	}

	public function getEventFacts()
	{
		return $this->belongsToMany('EventFacts', 'event_facts_keyword');
	}

	public function getActivities()
	{
		return $this->belongsToMany('Activity', 'activity_keyword');
	}

}