<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class GroupPermission extends Eloquent {

	protected $table = 'group_permissions';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function group()
	{
		return $this->belongsTo('App\Groups', 'id');
	}

	public function permission()
	{
		return $this->belongsTo('App\Permissions', 'id');
	}

}