<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class UserPermissions extends Eloquent {

	protected $table = 'user_permissions';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function user()
	{
		return $this->belongsTo('App\Users', 'id');
	}

	public function permission()
	{
		return $this->belongsTo('App\Permissions', 'id');
	}

}