<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('employees', function(Blueprint $table) {
			$table->foreign('manager_id')->references('id')->on('managers')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('employees', function(Blueprint $table) {
			$table->foreign('occupation_id')->references('id')->on('occupations')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('vestings', function(Blueprint $table) {
			$table->foreign('employee_id')->references('id')->on('employees')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('vestings', function(Blueprint $table) {
			$table->foreign('vacations_option_id')->references('id')->on('vacations_options')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('vacations', function(Blueprint $table) {
			$table->foreign('vesting_id')->references('id')->on('vestings')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('employees', function(Blueprint $table) {
			$table->dropForeign('employees_manager_id_foreign');
		});
		Schema::table('employees', function(Blueprint $table) {
			$table->dropForeign('employees_occupation_id_foreign');
		});
		Schema::table('vestings', function(Blueprint $table) {
			$table->dropForeign('vestings_employee_id_foreign');
		});
		Schema::table('vestings', function(Blueprint $table) {
			$table->dropForeign('vestings_vacations_option_id_foreign');
		});
		Schema::table('vacations', function(Blueprint $table) {
			$table->dropForeign('vacations_vesting_id_foreign');
		});
	}
}