<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('drivers', function(Blueprint $table) {
			$table->foreign('team_id')->references('id')->on('teams')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('races', function(Blueprint $table) {
			$table->foreign('track_id')->references('id')->on('tracks')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('events', function(Blueprint $table) {
			$table->foreign('location_id')->references('id')->on('locations')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('tracks', function(Blueprint $table) {
			$table->foreign('event_id')->references('id')->on('events')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('drivers', function(Blueprint $table) {
			$table->dropForeign('drivers_team_id_foreign');
		});
		Schema::table('races', function(Blueprint $table) {
			$table->dropForeign('races_track_id_foreign');
		});
		Schema::table('events', function(Blueprint $table) {
			$table->dropForeign('events_location_id_foreign');
		});
		Schema::table('tracks', function(Blueprint $table) {
			$table->dropForeign('tracks_event_id_foreign');
		});
	}
}