<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Track extends Eloquent {

	protected $table = 'tracks';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function event()
	{
		return $this->belongsTo('Event', 'event_id');
	}

	public function races()
	{
		return $this->hasMany('Race');
	}

}