<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class TransmissionBox extends Eloquent {

	protected $table = 'transmission_boxes';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function location()
	{
		return $this->belongsTo('CameraLocation', 'tbox_location_id');
	}

	public function driver()
	{
		return $this->belongsTo('Driver', 'driver_id');
	}

}