<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('store_account', function(Blueprint $table) {
			$table->foreign('company_id')->references('id')->on('companies')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('store_account', function(Blueprint $table) {
			$table->foreign('product_scheme_id')->references('id')->on('product_scheme')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('products', function(Blueprint $table) {
			$table->foreign('range_id')->references('id')->on('ranges')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('products', function(Blueprint $table) {
			$table->foreign('type_id')->references('id')->on('product_type')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('products', function(Blueprint $table) {
			$table->foreign('filling_id')->references('id')->on('product_filling')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('product_availability', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('products')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('product_availability', function(Blueprint $table) {
			$table->foreign('product_scheme_id')->references('id')->on('product_scheme')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('published_ranges', function(Blueprint $table) {
			$table->foreign('range_id')->references('id')->on('ranges')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('published_products', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('products')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('user_roles', function(Blueprint $table) {
			$table->foreign('role_id')->references('role_id')->on('user_roles')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_roles', function(Blueprint $table) {
			$table->foreign('user_id')->references('user_id')->on('user_roles')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('permission_roles', function(Blueprint $table) {
			$table->foreign('permission_id')->references('permission_id')->on('permission_roles')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('permission_roles', function(Blueprint $table) {
			$table->foreign('role_id')->references('role_id')->on('permission_roles')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('login_attempts', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('user')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('store_account', function(Blueprint $table) {
			$table->dropForeign('store_account_company_id_foreign');
		});
		Schema::table('store_account', function(Blueprint $table) {
			$table->dropForeign('store_account_product_scheme_id_foreign');
		});
		Schema::table('products', function(Blueprint $table) {
			$table->dropForeign('products_range_id_foreign');
		});
		Schema::table('products', function(Blueprint $table) {
			$table->dropForeign('products_type_id_foreign');
		});
		Schema::table('products', function(Blueprint $table) {
			$table->dropForeign('products_filling_id_foreign');
		});
		Schema::table('product_availability', function(Blueprint $table) {
			$table->dropForeign('product_availability_product_id_foreign');
		});
		Schema::table('product_availability', function(Blueprint $table) {
			$table->dropForeign('product_availability_product_scheme_id_foreign');
		});
		Schema::table('published_ranges', function(Blueprint $table) {
			$table->dropForeign('published_ranges_range_id_foreign');
		});
		Schema::table('published_products', function(Blueprint $table) {
			$table->dropForeign('published_products_product_id_foreign');
		});
		Schema::table('user_roles', function(Blueprint $table) {
			$table->dropForeign('user_roles_role_id_foreign');
		});
		Schema::table('user_roles', function(Blueprint $table) {
			$table->dropForeign('user_roles_user_id_foreign');
		});
		Schema::table('permission_roles', function(Blueprint $table) {
			$table->dropForeign('permission_roles_permission_id_foreign');
		});
		Schema::table('permission_roles', function(Blueprint $table) {
			$table->dropForeign('permission_roles_role_id_foreign');
		});
		Schema::table('login_attempts', function(Blueprint $table) {
			$table->dropForeign('login_attempts_user_id_foreign');
		});
	}
}