<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateRespondentsTable extends Migration {

	public function up()
	{
		Schema::create('respondents', function(Blueprint $table) {
			$table->string('email')->primary();
			$table->string('company_id', 7);
			$table->tinyInteger('active_flag')->default('1');
			$table->string('staff_code', 10);
			$table->string('firstname', 40);
			$table->string('lastname', 40);
			$table->string('affiliation_name_large', 200);
			$table->string('affiliation_name_medium', 200)->nullable();
			$table->string('affiliation_name_small', 200)->nullable();
			$table->string('hierarchy', 200);
			$table->string('position', 200)->nullable();
			$table->datetime('date_start')->nullable();
			$table->tinyInteger('gender')->nullable();
			$table->string('created_user');
			$table->string('updated_user')->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('respondents');
	}
}