<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('maintenances', function(Blueprint $table) {
			$table->foreign('client_id')->references('id')->on('clients')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('maintenances', function(Blueprint $table) {
			$table->foreign('mechanic_id')->references('id')->on('mechanics')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('maintenances', function(Blueprint $table) {
			$table->foreign('service_id')->references('id')->on('services')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('maintenances', function(Blueprint $table) {
			$table->foreign('bicycle_id')->references('id')->on('bicycles')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('clients', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('bicycles', function(Blueprint $table) {
			$table->foreign('client_id')->references('id')->on('clients')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('bicycles', function(Blueprint $table) {
			$table->foreign('make_id')->references('id')->on('makes')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('mechanics', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('requests', function(Blueprint $table) {
			$table->foreign('client_id')->references('id')->on('clients')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('requests', function(Blueprint $table) {
			$table->foreign('maintenance_id')->references('id')->on('maintenances')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('comments', function(Blueprint $table) {
			$table->foreign('maintenance_id')->references('id')->on('maintenances')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('ratings', function(Blueprint $table) {
			$table->foreign('maintenance_id')->references('id')->on('maintenances')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('maintenances', function(Blueprint $table) {
			$table->dropForeign('maintenances_client_id_foreign');
		});
		Schema::table('maintenances', function(Blueprint $table) {
			$table->dropForeign('maintenances_mechanic_id_foreign');
		});
		Schema::table('maintenances', function(Blueprint $table) {
			$table->dropForeign('maintenances_service_id_foreign');
		});
		Schema::table('maintenances', function(Blueprint $table) {
			$table->dropForeign('maintenances_bicycle_id_foreign');
		});
		Schema::table('clients', function(Blueprint $table) {
			$table->dropForeign('clients_user_id_foreign');
		});
		Schema::table('bicycles', function(Blueprint $table) {
			$table->dropForeign('bicycles_client_id_foreign');
		});
		Schema::table('bicycles', function(Blueprint $table) {
			$table->dropForeign('bicycles_make_id_foreign');
		});
		Schema::table('mechanics', function(Blueprint $table) {
			$table->dropForeign('mechanics_user_id_foreign');
		});
		Schema::table('requests', function(Blueprint $table) {
			$table->dropForeign('requests_client_id_foreign');
		});
		Schema::table('requests', function(Blueprint $table) {
			$table->dropForeign('requests_maintenance_id_foreign');
		});
		Schema::table('comments', function(Blueprint $table) {
			$table->dropForeign('comments_maintenance_id_foreign');
		});
		Schema::table('ratings', function(Blueprint $table) {
			$table->dropForeign('ratings_maintenance_id_foreign');
		});
	}
}