<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateBicyclesTable extends Migration {

	public function up()
	{
		Schema::create('bicycles', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('client_id')->unsigned();
			$table->integer('make_id')->unsigned();
			$table->string('model');
			$table->string('color')->nullable();
			$table->string('serial')->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('bicycles');
	}
}