<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Maintenance extends Eloquent {

	protected $table = 'maintenances';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function client()
	{
		return $this->belongsTo('Client');
	}

	public function mechanic()
	{
		return $this->belongsTo('Mechanic');
	}

	public function service()
	{
		return $this->belongsTo('Service');
	}

	public function bicycle()
	{
		return $this->belongsTo('Bicycle');
	}

}