<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Request extends Eloquent {

	protected $table = 'requests';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function client()
	{
		return $this->belongsTo('Client');
	}

	public function maintenance()
	{
		return $this->belongsTo('Maintenance');
	}

}